<?php defined('ROOT') || die() ?>

<div class="search-container d-flex flex-column align-items-center justify-content-center">

    <h3 class="font-weight-bolder text-dark mb-5"><?= $language->global->menu->search_title ?></h3>
    <form class="form-inline d-inline-flex justify-content-center search_form" action="" method="GET">
        <?php if($plugins->exists_and_active('facebook')): ?>
        <div class="dropdown my-2 mr-2">
            <button class="btn btn-default index-source-button dropdown-toggle border-0" data-source="instagram" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fab fa-instagram"></i> <?= ucfirst('instagram') ?></button>

            <div class="dropdown-menu">
                <?php foreach($sources as $source): ?>
                    <a class="dropdown-item source-select-item" href="#" data-source="<?= $source ?>"><i class="fab fa-<?= $source ?>"></i> <?= ucfirst($source) ?></a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif ?>

        <div class="my-2 index-input-div">
            <i class="fa fa-search text-black-50 index-search-input-icon"></i>
            <input class="form-control mr-2 index-search-input border-0 form-control-lg source_search_input" type="search" placeholder="<?= $language->global->menu->search_placeholder ?>">
        </div>

        <button type="submit" class="btn btn-light index-submit-button border-0 d-inline-block my-2"><?= $language->global->search ?></button>
    </form>

</div>



<script defer>
    $(document).ready(() => {
        <?php if($plugins->exists_and_active('facebook')): ?>
        $('.source-select-item').on('click', (event) => {
            let $this = $(event.currentTarget);
            let source = $this.data('source');
            let source_content = $this.html();

            $this.closest('form').find('.index-source-button').html(source_content).attr('data-source', source);

            switch(source) {
                case 'instagram':
                    $this.closest('form').find('.source_search_input').attr('placeholder', '<?= $language->global->menu->search_placeholder ?>');
                    break;

                case 'facebook':
                    $this.closest('form').find('.source_search_input').attr('placeholder', '<?= $language->facebook->global->menu->search_placeholder ?>');
                    break;
            }

            event.preventDefault();
        });
        <?php endif ?>

        $('.search_form').on('submit', (event) => {

            let source = $(event.currentTarget).closest('form').find('.index-source-button').length ? $(event.currentTarget).closest('form').find('.index-source-button').attr('data-source') : 'instagram';
            let search_input = $(event.currentTarget).find('.source_search_input').val();
            let username_array = [];
            let is_full_url = false;

            switch(source) {
                case 'instagram':
                    search_input.split('/').forEach((string) => {
                        if(string.trim() != '') {
                            username_array.push(string);

                            if(string.includes('instagram.com')) {
                                is_full_url = username_array.length - 1;
                            }
                        }
                    });
                    break;

                case 'facebook':
                    search_input.split('/').forEach((string) => {
                        if(string.trim() != '') {
                            username_array.push(string);

                            if(string.includes('facebook.com')) {
                                is_full_url = username_array.length - 1;
                            }
                        }
                    });
                    break;
            }


            let username = is_full_url !== false ? username_array[is_full_url + 1] : username_array[username_array.length - 1];

            if(username.length > 0) {

                $('body').addClass('animated fadeOut');
                setTimeout(() => {
                    window.location.href = `<?= $settings->url ?>report/${username}/${source}`;
                }, 70)

            }

            event.preventDefault();
        });
    })
</script>
