<?php defined('ROOT') || die() ?>

<div class="row">
    <div class="col-md-8">

        <div class="text-white no-underline card bg-instagram bg-instagram-favorites mb-1">
            <div class="card-body d-flex justify-content-between">
                <div>
                    <i class="fab fa-instagram"></i> <?= $language->favorites->display->instagram; ?>
                </div>

                <div class=""><?= $favorites['instagram']['count'] ?? 0 ?></div>
            </div>
        </div>


        <?php if($favorites['instagram']['result']->num_rows == 0): ?>

            <?= $language->favorites->info_message->no_favorites ?>

        <?php else: ?>

            <table class="table table-responsive-md mt-3">
                <thead class="thead-dark">
                <tr>
                    <th><?= $language->report->display->user ?></th>
                    <th><?= $language->report->display->followers ?></th>
                    <th><?= $language->report->display->following ?></th>
                    <th><?= $language->report->display->uploads ?></th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <?php while($source_account = $favorites['instagram']['result']->fetch_object()): ?>
                    <tr>
                        <td><a href="report/<?= $source_account->username ?>/instagram">@<?= $source_account->username ?></a></td>
                        <td><?= nr($source_account->followers) ?></td>
                        <td><?= nr($source_account->following) ?></td>
                        <td><?= nr($source_account->uploads) ?></td>
                        <td>
                            <a href="#" id="favorite" onclick="return favorite(event)" data-id="<?= $source_account->id ?>" data-source="instagram" class="text-dark">
                                <?= $language->report->display->remove_favorite ?>
                            </a>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>

        <?php endif; ?>

        <?php
        if($plugins->exists_and_active('facebook')) {
            require_once $plugins->require('facebook', 'views/favorites');
        }
        ?>
    </div>

    <div class="col-md-4">
        <?php require VIEWS_ROUTE . 'shared_includes/widgets/sidebar.php'; ?>
    </div>
</div>
