<?php defined('ROOT') || die() ?>

<div class="card card-shadow">
    <div class="card-body">
        <h4><?= $language->admin_extra_settings->header2 ?></h4>
        <p class="text-muted"><?= $language->admin_extra_settings->subheader2 ?></p>


        <div class="mt-5">
            <?php if(!$plugins_result->num_rows): ?>

                <?= $language->admin_extra_settings->display->no_plugins ?>

            <?php else: ?>
                <?php while($plugin = $plugins_result->fetch_object()): ?>

                    <div class="media">
                        <div class="mr-3 plugin" style="background: <?= $plugin->color ?>"><?= substr($plugin->name, 0) ?></div>

                        <div class="media-body">
                            <h6 class="my-0"><?= $plugin->name ?></h6>
                            <small><?= $plugin->version ?></small>
                        </div>

                        <div>
                            <?php if($plugins->get($plugin->identifier)): ?>

                                <?php if($plugin->status): ?>
                                    <a href="admin/extra-settings/plugin_status/<?= $plugin->id . '/' . Security::csrf_get_session_token('url_token') ?>" class="btn btn-sm btn-primary"><?= $language->admin_extra_settings->display->deactivate ?></a>
                                <?php else: ?>
                                    <a href="admin/extra-settings/plugin_status/<?= $plugin->id . '/' . Security::csrf_get_session_token('url_token') ?>" class="btn btn-sm btn-light"><?= $language->admin_extra_settings->display->activate ?></a>
                                <?php endif ?>

                            <?php else: ?>
                                <a href="https://codecanyon.net/item/facebook-analytics-for-phpanalyzer/23535790?ref=altumcode" class="btn btn-sm btn-success"><i class="fa fa-cloud-download-alt"></i> <?= $language->admin_extra_settings->display->get ?></a>
                            <?php endif ?>
                        </div>
                    </div>

                <?php endwhile ?>
            <?php endif ?>
        </div>
    </div>
</div>


<div class="card card-shadow  mt-3">
    <div class="card-body">
        <h4><?= $language->admin_extra_settings->header ?></h4>
        <p class="text-muted"><?= $language->admin_extra_settings->subheader ?></p>

        <form action="" method="post" role="form">
            <input type="hidden" name="form_token" value="<?= Security::csrf_get_session_token('form_token') ?>" />
            <input type="hidden" name="type" value="reset" />

            <div class="form-check">
                <label class="form-check-label">
                    <input type="checkbox" class="form-check-input" name="users">
                    <?= $language->admin_extra_settings->input->reset_users  ?>
                    <small class="text-muted"><?= $language->admin_extra_settings->input->reset_users_help ?></small>
                </label>
            </div>

            <div class="form-check">
                <label class="form-check-label">
                    <input type="checkbox" class="form-check-input" name="instagram_users">
                    <?= $language->admin_extra_settings->input->reset_instagram ?>
                    <small class="text-muted"><?= $language->admin_extra_settings->input->reset_instagram_help ?></small>
                </label>
            </div>

            <div class="form-check">
                <label class="form-check-label">
                    <input type="checkbox" class="form-check-input" name="instagram_logs">
                    <?= $language->admin_extra_settings->input->reset_instagram_logs ?>
                </label>
            </div>

            <?php

            if($plugins->exists_and_active('facebook')) {
                require_once $plugins->require('facebook', 'views/admin/extra_settings');
            }

            ?>

            <div class="text-center">
                <button type="submit" name="submit" class="btn btn-primary btn-sm" data-confirm="<?= $language->global->info_message->confirm_delete ?>"><?= $language->global->submit_button ?></button>
            </div>
        </form>

    </div>
</div>


<div class="card card-shadow mt-3">
    <div class="card-body">

        <h5><?= $language->admin_extra_settings->display->demo_reports ?></h5>
        <p class="text-muted"><?= $language->admin_extra_settings->display->demo_reports_help ?></p>

        <table class="table table-hover">
            <thead class="thead-dark thead-inverse">
            <tr>
                <th>#</th>
                <th><?= $language->admin_extra_settings->table->username ?></th>
                <th><?= $language->admin_extra_settings->table->source ?></th>
                <th><?= $language->admin_extra_settings->table->actions ?></th>
            </tr>
            </thead>
            <tbody>

            <?php while($data = $demo_users_result->fetch_object()): ?>

                <tr>
                    <td><?= $data->id ?></td>
                    <td><?= $data->username ?></td>
                    <td><i class="fab fa-<?= $data->source ?> text-<?= $data->source ?>"></i> <?= $data->source ?></td>
                    <td>
                        <a data-confirm="<?= $language->global->info_message->confirm_delete ?>" href="admin/extra-settings/demo_delete/<?= $data->id . '/' . Security::csrf_get_session_token('url_token') . '/' . $data->source  ?>" class="no-underline"><?= $language->global->delete ?></a>
                    </td>
                </tr>

            <?php endwhile ?>

            <tr>
                <td colspan="4">
                    <form class="form-inline" action="" method="post" role="form">
                        <input type="hidden" name="form_token" value="<?= Security::csrf_get_session_token('form_token') ?>" />
                        <input type="hidden" name="type" value="demo_reports" />

                        <div class="mr-4">
                            <i class="fa fa-plus fa-1x"></i>
                        </div>

                        <div class="form-group mr-4">
                            <input type="text" name="username" class="form-control" placeholder="<?= $language->admin_extra_settings->input->username ?>" value="" required="required" />
                        </div>

                        <div class="form-group mr-4">
                            <select class="custom-select" name="source">
                                <option value="instagram">Instagram</option>

                                <?php if($plugins->exists_and_active('facebook')): ?>
                                <option value="facebook">Facebook</option>
                                <?php endif ?>

                            </select>
                        </div>

                        <div class="text-center">
                            <button type="submit" name="submit" class="btn btn-primary"><?= $language->global->submit_button ?></button>
                        </div>
                    </form>
                </td>
            </tr>

            </tbody>
        </table>

    </div>
</div>

