<?php
defined('ROOT') || die();

/* Defining the future projections data */
$total_days = count($logs) > 1 ? (new \DateTime($logs[count($logs)-1]['date']))->diff((new \DateTime($logs[1]['date'])))->format('%a') : 0;

/* Media details */
$instagram_media_result = $database->query("SELECT * FROM `instagram_media` WHERE `instagram_user_id` = '{$source_user_id}' ORDER BY `created_date` DESC LIMIT {$settings->instagram_calculator_media_count}");

$mpdf->SetTitle(sprintf($language->pdf->title, $source_account->username));

$mpdf->WriteHTML('
        <table>
            <tr>
    ');

$mpdf->WriteHTML('
                <td>
                    <img src="' . $source_account->profile_picture_url .'" class="profile-picture" />
                </td>
    ');

$mpdf->WriteHTML('
                <td>
                    <h1>' . sprintf($language->pdf->display->header, $source_account->username) . '</h1>
                </td>
    ');


$mpdf->WriteHTML('
            </tr>
        </table>
    ');

$mpdf->WriteHTML('<h5>' . sprintf($language->pdf->display->subheader, 'https://instagram.com/'.$source_account->username, $source_account->username) . '</h5>');

$mpdf->WriteHTML('<h5>' . sprintf($language->pdf->display->subheader_help, $settings->instagram_calculator_media_count) . '</h5>');



$mpdf->WriteHTML('<hr />');

$mpdf->WriteHTML('<h3>' . $language->pdf->display->engagement_header . '</h3>');

$mpdf->WriteHTML(
    '<ul>
        <li><strong>' . $language->pdf->display->engagement_rate . '</strong> <small>(' . $language->pdf->display->engagement_rate_help . ')</small></li>
            <span>' . nr($source_account->average_engagement_rate, 2) . '%</span>
        <li><strong>' . $language->pdf->display->average_likes . '</strong></li>
            <span>' . $source_account_details->average_likes . '</span>
        <li><strong>' . $language->pdf->display->average_comments . '</strong></li>
            <span>' . $source_account_details->average_comments . '</span>
        <li><strong>' . $language->pdf->display->followers . '</strong></li>
            <span>' . nr($source_account->followers) . '</span>
        <li><strong>' . $language->pdf->display->following . '</strong></li>
            <span>' . nr($source_account->following) . '</span>
        <li><strong>' . $language->pdf->display->uploads . '</strong></li>
            <span>' . nr($source_account->uploads) . '</span>
    </ul>
    ');

$mpdf->WriteHTML('<h3>' . $language->pdf->display->stats_header . '</h3>');


$mpdf->WriteHTML(
    '<table autosize="1" width="100%">
        <thead>
            <tr>
                <th>' . $language->pdf->display->date . '</th>
                <th></th>
                <th>' . $language->pdf->display->followers . '</th>
                <th></th>
                <th>' . $language->pdf->display->following . '</th>
                <th></th>
                <th>' . $language->pdf->display->uploads . '</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
    ');

$total_new = [
    'followers' => 0,
    'uploads'   => 0
];

/* Iterate over the logs */
for($i = 0; $i < count($logs); $i++) {
    $log_yesterday = ($i == count($logs) - 1) ? false : $logs[$i+1];
    $log = $logs[$i];
    $date = (new \DateTime($log['date']))->format($language->global->date->datetime_format);
    $date_name = $language->global->date->short_day_of_week->{(new \DateTime($log['date']))->format('N')};
    $followers_difference = $log_yesterday ? $log['followers'] - $log_yesterday['followers'] : 0;
    $following_difference = $log_yesterday ? $log['following'] - $log_yesterday['following'] : 0;
    $uploads_difference = $log_yesterday ? $log['uploads'] - $log_yesterday['uploads'] : 0;

    $total_new['followers'] += $followers_difference;
    $total_new['uploads'] += $uploads_difference;

    /* Write to the pdf */
    $mpdf->WriteHTML('
            <tr>
                <td>' . $date . '</td>
                <td>' . $date_name . '</td>
                <td>' . nr($log['followers']) . '</td>
                <td>' . colorful_number($followers_difference) . '</td>
                <td>' . nr($log['following']) . '</td>
                <td>' . colorful_number($following_difference) . '</td>
                <td>' . nr($log['uploads']) . '</td>
                <td>' . colorful_number($uploads_difference) . '</td>
            </tr>
        ');
}


$average_followers = $total_days > 0 ? (int) ceil($total_new['followers'] / $total_days) : 0;
$average_uploads = $total_days > 0 ? (int) ceil($total_new['uploads'] / $total_days) : 0;


$mpdf->WriteHTML('
        <tr>
            <td colspan="2"><strong>' . $language->pdf->display->total_summary . '</strong></td>
            <td colspan="4">' . colorful_number(nr($total_new['followers'])) . '</td>
            <td colspan="2">' . colorful_number(nr($total_new['uploads'])) . '</td>
        </tr>
    ');

$mpdf->WriteHTML('</tbody></table>');

$mpdf->AddPage();

$mpdf->WriteHTML('<h3>' . $language->pdf->display->projections_header . '</h3>');
$mpdf->WriteHTML('<p class="text-muted">' . $language->pdf->display->projections_help . '</p>');

$mpdf->WriteHTML('
        <table autosize="1" width="100%">
            <thead>
                <tr>
                    <th>' . $language->pdf->display->time_until . '</th>
                    <th>' . $language->pdf->display->date . '</th>
                    <th>' . $language->pdf->display->followers . '</th>
                    <th>' . $language->pdf->display->uploads . '</th>
                </tr>
            </thead>
            
            <tbody>
                <tr>
                    <td>' . $language->pdf->display->time_until_now . '</td>
                    <td>' . (new \DateTime())->format($language->global->date->datetime_format) . '</td>
                    <td>' . nr($source_account->followers) . '</td>
                    <td>' . nr($source_account->uploads) . '</td>
                </tr>
    ');


if($total_days < 2) {

    $mpdf->WriteHTML('<tr><td colspan="4">' . $language->pdf->display->no_projections . '</td></tr>');


} else {

    $mpdf->WriteHTML('
            <tr>
                <td>' . sprintf($language->global->date->x_days, 30) . '</td>
                <td>' . (new \DateTime())->modify('+30 day')->format($language->global->date->datetime_format) . '</td>
                <td>' . nr($source_account->followers + ($average_followers * 30)) . '</td>
                <td>' . nr($source_account->uploads + ($average_uploads * 30)) . '</td>
            </tr>
        
            <tr>
                <td>' . sprintf($language->global->date->x_days, 60) . '</td>
                <td>' . (new \DateTime())->modify('+60 day')->format($language->global->date->datetime_format) . '</td>
                <td>' . nr($source_account->followers + ($average_followers * 60)) . '</td>
                <td>' . nr($source_account->uploads + ($average_uploads * 60)) . '</td>
            </tr>
        
            <tr>
                <td>' . sprintf($language->global->date->x_months, 3) . '</td>
                <td>' . (new \DateTime())->modify('+90 day')->format($language->global->date->datetime_format) . '</td>
                <td>' . nr($source_account->followers + ($average_followers * 90)) . '</td>
                <td>' . nr($source_account->uploads + ($average_uploads * 90)) . '</td>
            </tr>
        
            <tr>
                <td>' . sprintf($language->global->date->x_months, 6) . '</td>
                <td>' . (new \DateTime())->modify('+180 day')->format($language->global->date->datetime_format) . '</td>
                <td>' . nr($source_account->followers + ($average_followers * 180)) . '</td>
                <td>' . nr($source_account->uploads + ($average_uploads * 180)) . '</td>
            </tr>
        
            <tr>
                <td>' . sprintf($language->global->date->x_months, 9) . '</td>
                <td>' . (new \DateTime())->modify('+270 day')->format($language->global->date->datetime_format) . '</td>
                <td>' . nr($source_account->followers + ($average_followers * 270)) . '</td>
                <td>' . nr($source_account->uploads + ($average_uploads * 270)) . '</td>
            </tr>
        
            <tr>
                <td>' . sprintf($language->global->date->year) . '</td>
                <td>' . (new \DateTime())->modify('+365 day')->format($language->global->date->datetime_format) . '</td>
                <td>' . nr($source_account->followers + ($average_followers * 365)) . '</td>
                <td>' . nr($source_account->uploads + ($average_uploads * 365)) . '</td>
            </tr>
        
            <tr>
                <td>' . sprintf($language->global->date->year_and_half) . '</td>
                <td>' . (new \DateTime())->modify('+547 day')->format($language->global->date->datetime_format) . '</td>
                <td>' . nr($source_account->followers + ($average_followers * 547)) . '</td>
                <td>' . nr($source_account->uploads + ($average_uploads * 547)) . '</td>
            </tr>
        
            <tr>
                <td>' . sprintf($language->global->date->x_years, 2, $language->global->number->decimal_point, $language->global->number->thousands_separator) . '</td>
                <td>' . (new \DateTime())->modify('+730 day')->format($language->global->date->datetime_format) . '</td>
                <td>' . nr($source_account->followers + ($average_followers * 730)) . '</td>
                <td>' . nr($source_account->uploads + ($average_uploads * 730)) . '</td>
            </tr>
        
            <tr>
                <th colspan="2"><strong>' . $language->report->display->average_calculations . '</strong></th>
                <td>' . sprintf($language->report->display->followers_per_day, colorful_number(nr($average_followers))) . '</td>
                <td>' . sprintf($language->report->display->uploads_per_day, colorful_number(nr($average_uploads))) . '</td>
            </tr>
        ');

}

$mpdf->WriteHTML('
            </tbody>
        </table>
    ');


if($instagram_media_result->num_rows) {
    $mpdf->AddPage();

    $mpdf->WriteHTML('<h3>' . $language->pdf->display->media_summary . '</h3>');
    $mpdf->WriteHTML('<p class="text-muted">' . sprintf($language->pdf->display->media_summary_help, $settings->instagram_calculator_media_count) . '</p>');


    $mpdf->WriteHTML('
        <table autosize="1" width="100%">
            <thead>
                <tr>
                    <th></th>
                    <th>' . $language->pdf->display->media_created_date . '</th>
                    <th>' . $language->pdf->display->media_type . '</th>
                    <th>' . $language->pdf->display->media_likes . '</th>
                    <th>' . $language->pdf->display->media_comments . '</th>
                </tr>
            </thead>
            <tbody>
        ');

    while($media = $instagram_media_result->fetch_object()) {

        $mpdf->WriteHTML('
                <tr>
                    <td><a href="' . $media->media_url . '" target="_blank">' . sprintf($language->pdf->display->media_media_url, $media->media_url) . '</a></td>
                    <td>' . (new \DateTime())->setTimestamp($media->created_date)->format($language->global->date->datetime_format) . '</td>
                    <td>' . strtolower($media->type) . '</td>
                    <td>' . nr($media->likes) . '</td>
                    <td>' . nr($media->comments) . '</td>
                </tr>
            ');

    }


    $mpdf->WriteHTML('
                </tbody>
            </table>
        ');
}


/* Mentions and hashtags */
if(count((array) $source_account_details->top_mentions) > 0 || count((array) $source_account_details->top_hashtags) > 0) {
    $mpdf->AddPage();

    $mpdf->WriteHTML('
        <table autosize="1" width="100%">
            <tbody>
                <tr>
        ');
}

if(count((array) $source_account_details->top_mentions) > 0) {

    $mpdf->WriteHTML('
            <td>
                <h3>' . $language->pdf->display->top_mentions . '</h3>
        ');

    foreach((array) $source_account_details->top_mentions as $mention => $use) {
        $mpdf->WriteHTML('
                <a href="https://www.instagram.com/' . $mention . '" target="_blank">@' . $mention . '</a> - ' . sprintf($language->pdf->display->x_uses, $use) . '<br />
            ');
    }

    $mpdf->WriteHTML('</td>');

}


if(count((array) $source_account_details->top_hashtags) > 0) {

    $mpdf->WriteHTML('
            <td>
            <h3>' . $language->pdf->display->top_hashtags . '</h3>
        ');

    foreach((array) $source_account_details->top_hashtags as $hashtag => $use) {
        $mpdf->WriteHTML('
                <a href="https://www.instagram.com/explore/tags/' . $hashtag . '" target="_blank">#' . $hashtag . '</a> - ' . sprintf($language->pdf->display->x_uses, $use) . '<br />
            ');
    }

    $mpdf->WriteHTML('</td>');

}

if(count((array) $source_account_details->top_mentions) > 0 || count((array) $source_account_details->top_hashtags) > 0) {
    $mpdf->WriteHTML('
                </tr>
            </tbody>
        </table>
        ');
}
