<?php

class Plugins {
    public $plugins = [];

    public function __construct() {

        // ^_^

    }

    public function get($identifier) {

        if(in_array($identifier, $this->plugins)) {
            return $this->plugins[$identifier];
        } else {

            $plugin = Database::get('*', 'plugins', ['identifier' => $identifier]);

            if($plugin && file_exists(ROOT . PLUGINS_ROUTE . $plugin->identifier)) {
                $this->plugins[$plugin->identifier] = $plugin;

                return $this->plugins[$plugin->identifier];
            } else {

                $this->plugins[$identifier] = false;

                return false;

            }
        }

    }

    public function exists_and_active($identifier) {

        $plugin = $this->get($identifier);

        if($plugin) {

            return $this->plugins[$identifier]->status ? $this->plugins[$identifier] : false;

        } else {
            return false;
        }

    }

    public function require($identifier, $path, $extension = '.php') {

        if($plugin = $this->exists_and_active($identifier)) {

            return ROOT . PLUGINS_ROUTE . $plugin->identifier . '/' . $path . $extension;

        } else {

            throw new Exception($identifier . ' plugin does not exist or it is not active.');

        }


    }
}
