<?php
defined('ROOT') || die();

/* Make sure we have the needed params */
if(!isset($_GET['username'], $_GET['api_key'])) {
    http_response_code(403); die();
}

$source = isset($_GET['source']) && in_array($_GET['source'], $sources) ? Database::clean_string($_GET['source']) : 'instagram';

$table = $source . '_users';
$logs_table = $source . '_logs';

/* If the source is other than instagram, make sure its active */
if($source != 'instagram') {
    if(!$plugins->exists_and_active($source)) {
        redirect('my-reports');
    }
}

/* Make sure the requested id is an actual existing record in the database */
if(!$source_user_id = Database::simple_get('id', $table, ['username' => $_GET['username']])) {
    $_SESSION['error'][] = $language->pdf->error_message->not_found;  redirect('my-reports');
}

if($settings->store_unlock_report_price != '0') {
    /* Make sure the API key is correct */
    $profile_account = Database::get(['user_id', 'type'], 'users', ['api_key' => $_GET['api_key']]);

    if(!$profile_account) {
        $_SESSION['error'][] = $language->pdf->error_message->unauthorized; redirect('my-reports');
    }

    /* Make sure the username exists and the user has access to it */
    if (!User::has_valid_report($source_user_id, $profile_account->user_id, $source) && $profile_account->type != '1') {
        $_SESSION['error'][] =  $language->api->error_message->unauthorized; redirect('my-reports');
    }
}

/* Get source account details */
$source_account = Database::get('*', $table, ['id' => $source_user_id]);
$source_account_details = json_decode($source_account->details);

/* Gather the logs */
$logs = [];
$logs_result = $database->query("SELECT * FROM `{$logs_table}` WHERE `{$source}_user_id` = '{$source_user_id}' ORDER BY `date` DESC LIMIT 15");
while($log = $logs_result->fetch_assoc()) { $logs[] = $log; }

/* Start setting up the pdf */
$mpdf = new \Mpdf\Mpdf(['tempDir' => ROOT . UPLOADS_ROUTE . 'pdf_tmp']);

/* Include the css styling */
$stylesheet = file_get_contents(ROOT. ASSETS_ROUTE . 'css/pdf.css');

$mpdf->WriteHTML($stylesheet,\Mpdf\HTMLParserMode::HEADER_CSS);

/* Include the source modifications */
require_once $source == 'instagram' ? ROOT . SOURCES_ROUTE . $source . '/controllers/pdf.php' : $plugins->require($source, 'controllers/pdf');

$mpdf->Output();

$controller_has_view = false;
