<?php
defined('ROOT') || die();

/* Initiation */
set_time_limit(0);

/* *****************/
/* Email reporting */
/* *****************/

if($settings->email_reports) {

    switch ($settings->email_reports_frequency) {
        case 'DAILY':
            $timestampdiff = 'DAY';
            $timestampdiff_compare = '0';
            break;

        case 'WEEKLY':
            $timestampdiff = 'DAY';
            $timestampdiff_compare = '6';

            break;

        case 'MONTHLY':
            $timestampdiff = 'MONTH';
            $timestampdiff_compare = '0';

            break;
    }


    /* Include the Instagram default email cron */
    require_once ROOT . SOURCES_ROUTE . 'instagram/controllers/cron_emails.php';

    /* Include other sources email cron */
    if($plugins->exists_and_active('facebook')) {
        require_once $plugins->require('facebook', 'controllers/cron_emails');
    }
}

/* **********************/
/* Accounts Checking    */
/* **********************/
$is_proxy_request = false;

/* Check if we need to use a proxy */
if($settings->proxy) {

    /* Select a proxy at random from the database */
    $proxy = $database->query("SELECT * FROM `proxies` ORDER BY RAND() LIMIT 1");

    if($proxy->num_rows) {

        $proxy = $proxy->fetch_object();

        $rand = rand(1, 10);

        /* Give it a 50 - 50 percent chance to choose from the server or from the proxy in case the proxy is not exclusive */
        if($settings->proxy_exclusive || (!$settings->proxy_exclusive && $rand > 5)) {

            $is_proxy_request = [
                'address' => $proxy->address,
                'port'    => $proxy->port,
                'tunnel'  => true,
                'timeout' => $settings->proxy_timeout,
                'auth'    => [
                    'user' => $proxy->username,
                    'pass' => $proxy->password,
                    'method' => $proxy->method
                ]
            ];

        }

    }

}

/* Include the Instagram default accounts cron */
require_once ROOT . SOURCES_ROUTE . 'instagram/controllers/cron_reports.php';

/* Include other sources accounts cron */
if($plugins->exists_and_active('facebook')) {
    require_once $plugins->require('facebook', 'controllers/cron_reports');
}

$controller_has_view = false;
