<?php
defined('ROOT') || die();
User::check_permission(1);

$type 		= isset($parameters[0]) ? $parameters[0] : false;
$id 	    = isset($parameters[1]) ? (int) $parameters[1] : false;
$url_token	= isset($parameters[2]) ? $parameters[2] : false;
$source     = isset($parameters[3]) && in_array($parameters[3], $sources) ? $parameters[3] : 'instagram';

if(isset($type) && $type == 'plugin_status') {

    /* Check for errors and permissions */
    if(!Security::csrf_check_session_token('url_token', $url_token)) {
        $_SESSION['error'][] = $language->global->error_message->invalid_token;
    }

    if(!$plugin = Database::get(['status'], 'plugins', ['id' => $id])) {
        redirect('admin/extra-settings');
    }

    if(empty($_SESSION['error'])) {
        $new_status = (int) !$plugin->status;
        $database->query("UPDATE `plugins` SET `status` = {$new_status} WHERE `id` = {$id}");

        $_SESSION['success'][] = $language->global->success_message->basic;

        redirect('admin/extra-settings');
    }
}

if(isset($type) && $type == 'demo_delete') {

    /* Check for errors and permissions */
    if(!Security::csrf_check_session_token('url_token', $url_token)) {
        $_SESSION['error'][] = $language->global->error_message->invalid_token;
    }

    if(empty($_SESSION['error'])) {

        $table = $source . '_users';

        $database->query("UPDATE {$table} SET `is_demo` = 0 WHERE `id` = {$id}");

        $_SESSION['success'][] = $language->global->success_message->basic;

        redirect('admin/extra-settings');
    }
}

if(!empty($_POST)) {
    if (!empty($_POST['type']) && $_POST['type'] == 'reset') {

        if(!Security::csrf_check_session_token('form_token', $_POST['form_token'])) {
            $_SESSION['error'][] = $language->global->error_message->invalid_token;
        }

        if(empty($_SESSION['error'])) {

            if(isset($_POST['users'])) {
                $database->query("DELETE FROM `users` WHERE `user_id` != {$account_user_id}");
                $database->query("DELETE FROM `unlocked_reports` WHERE `user_id` != {$account_user_id}");
                $database->query("DELETE FROM `favorites` WHERE `user_id` != {$account_user_id}");
                $database->query("DELETE FROM `payments` WHERE `user_id` != {$account_user_id}");
            }

            if(isset($_POST['instagram_users'])) {
                $database->query("DELETE FROM `instagram_users`");
                $database->query("DELETE FROM `unlocked_reports` WHERE `source` = 'INSTAGRAM'");
                $database->query("DELETE FROM `favorites` WHERE `source` = 'INSTAGRAM'");
            }

            if(isset($_POST['instagram_logs'])) {
                $database->query("DELETE FROM `instagram_logs`");
            }

            if($plugins->exists_and_active('facebook')) {
                require_once $plugins->require('facebook', 'views/admin/extra_settings');
            }

            /* Set message & Redirect */
            $_SESSION['success'][] = $language->global->success_message->basic;

        }
    }

    if(!empty($_POST['type']) && $_POST['type'] == 'demo_reports') {
        $_POST['username']  = Database::clean_string($_POST['username']);
        $_POST['source']    = in_array($_POST['source'], $sources) ? Database::clean_string($_POST['source']) : 'instagram';
        $last_checked_date  = (new \DateTime())->modify('-1 years')->format($language->global->date->datetime_format . ' H:i:s');

        if(!Security::csrf_check_session_token('form_token', $_POST['form_token'])) {
            $_SESSION['error'][] = $language->global->error_message->invalid_token;
        }

        if(empty($_SESSION['error'])) {

            $table = $_POST['source'] . '_users';

            if ($exists = Database::exists('username', $table, ['username' => $_POST['username']])) {

                $database->query("UPDATE `{$table}` SET `is_demo` = 1 WHERE `username` = '{$_POST['username']}'");

            } else {

                $sql = "INSERT INTO `instagram_users` (`username`, `full_name`, `description`, `added_date`, `last_check_date`, `is_demo`) VALUES ('{$_POST['username']}', '{$language->report->state->not_checked_full_name}', '{$language->report->state->not_checked_description}', '{$date}', '{$last_checked_date}', '1')";

                if($plugins->exists_and_active('facebook')) {
                    $sql = "INSERT INTO `facebook_users` (`username`, `name`, `added_date`, `last_check_date`, `is_demo`) VALUES ('{$_POST['username']}', '{$language->report->state->not_checked_full_name}', '{$date}', '{$last_checked_date}', '1')";
                }

                $database->query($sql);

            }

            $_SESSION['success'][] = $language->global->success_message->basic;

        }

    }

}

$demo_users_sql = "SELECT `username`, `id`, 'instagram' AS `source` FROM `instagram_users` WHERE `is_demo` = 1";

if($plugins->exists_and_active('facebook')) {
    $demo_users_sql .= " UNION SELECT `username`, `id`, 'facebook' AS `source` FROM `facebook_users` WHERE `is_demo` = 1";
}

$demo_users_result = $database->query($demo_users_sql);

$plugins_result = $database->query("SELECT * FROM `plugins`");
